﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CashierCrisis.Entities;
using System.Xml.Serialization;

namespace CashierCrisis.Behaviors
{
    [XmlRoot("Composite")]
    public abstract class Composite : Behavior
    {
        [XmlArray("Children")]
        public List<Behavior> Children { get; protected set; }

        //[XmlIgnore]
        //public override Entity Entity
        //{
        //    get
        //    {
        //        return base.Entity;
        //    }
        //    set
        //    {
        //        base.Entity = value;
        //        if (IsRoot || Children.Count > 0)
        //        {
        //            for (int i = 0; i < Children.Count; i++)
        //            {
        //                if (Children[i].Entity != this.Entity)
        //                {
        //                    Children[i].Entity = this.Entity;
        //                }
        //            }
        //        }

               
        //    }
        //}

        public Composite()
        {
            Children = new List<Behavior>();
        }

        public override Behavior Add(Behavior behavior)
        {
            Attach(behavior);
            Children.Add(behavior);
            return behavior;
        }
    }
}
